#pragma NOIV               // Do not generate interrupt vectors
//-----------------------------------------------------------------------------
//   File:      periph.c
//   Contents:   Hooks required to implement USB peripheral function.
//
//   Copyright (c) 1997 AnchorChips, Inc. All rights reserved
//-----------------------------------------------------------------------------
// Modified for N2PK VNA
// Modifications (C) 2004 Dave Roberts G8KBB
// 14 Sept 2006 - extended for VNAccess.dll
// 08 Nov 2006 - significant rewrite

#include "fx2.h"
#include "fx2regs.h"
#include "fx2sdly.h"            // SYNCDELAY macro
#include "vna.h"

BYTE	*res1 _at_ 0x2a;
BYTE  	*res2 _at_ 0x2d;
BYTE   AdcMode _at_ 0x28;            // flags for which ADC and ADC mode
BYTE	i _at_ 0x29;

//void Foo( WORD p1, WORD p2, BYTE nAdcMode)
void Foo(void)
{
#ifdef ZXNZXZMXZNXM
	BYTE i,j,k,n,m;
#else
	BYTE k,m;
#endif
//	BYTE *pRes1 = (BYTE *)p1;
//	BYTE *pRes2 = (BYTE *)p2;
	
	// set mask to get bits of ADC mode for ltc2440
#ifdef ZXNZXZMXZNXM
	n = 0x10;
#endif
	// 4 bytes of data (32 bits)
	for( i=0; i<4; i++)
	{
		// no need to clear next byte to start with (shift data in)
		// AdcInData[i] = 0;
		// step thru each bit of data
		// use variable k,m to accumulate byte of data
		k = 0;
		m = 0;
		if( i == 0 )
		{
#ifdef ZXNZXZMXZNXM
			for( j = 0x80; j != 0; j >>= 1 )
			{
				// in case this is an ltc2440, shift out mode on SDI pin
				// only do this for the first 5 bits
				// 23-05-06 change
				// when doing exeter I found that if SDI bit was left high
				// it caused problems so pulled low when OSR has been sent.
				IOA &= ~bmAdcSdiPin;
				if( AdcMode & n )
					IOA |= bmAdcSdiPin;
				n >>= 1;
				// set clock high (clocks SDI in and SDO out)
				IOB |= bmADCnSClkPin;
				// wait for lines to settle
				SYNCDELAY;
				// read data bit
				if(  ( IOA & bmADC1SdoPin ) == 0 )
					k |= j;
				if(  ( IOB & bmADC2SdoPin ) == 0 )
					m |= j;
				IOB &= ~bmADCnSClkPin;
			}
#else
			IOA &= ~bmAdcSdiPin;
			if( AdcMode & 0x10 )
				IOA |= bmAdcSdiPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x80;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x80;
			IOB &= ~bmADCnSClkPin;
			IOA &= ~bmAdcSdiPin;
			if( AdcMode & 0x8 )
				IOA |= bmAdcSdiPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x40;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x40;
			IOB &= ~bmADCnSClkPin;
			IOA &= ~bmAdcSdiPin;
			if( AdcMode & 0x4 )
				IOA |= bmAdcSdiPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x20;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x20;
			IOB &= ~bmADCnSClkPin;
			IOA &= ~bmAdcSdiPin;
			if( AdcMode & 0x2 )
				IOA |= bmAdcSdiPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x10;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x10;
			IOB &= ~bmADCnSClkPin;
			IOA &= ~bmAdcSdiPin;
			if( AdcMode & 0x1 )
				IOA |= bmAdcSdiPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x8;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x8;
			IOB &= ~bmADCnSClkPin;
			IOA &= ~bmAdcSdiPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x4;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x4;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x2;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x2;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x1;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x1;
//			if( i != 3 )
				IOB &= ~bmADCnSClkPin;

#endif
		}
		else
		{
			IOB |= bmADCnSClkPin;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x80;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x80;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x40;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x40;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x20;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x20;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x10;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x10;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x8;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x8;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x4;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x4;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x2;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x2;
			IOB &= ~bmADCnSClkPin;
			SYNCDELAY;
			IOB |= bmADCnSClkPin;
			SYNCDELAY;
			SYNCDELAY;
			if(  ( IOA & bmADC1SdoPin ) == 0 ) k |= 0x1;
			if(  ( IOB & bmADC2SdoPin ) == 0 ) m |= 0x1;
			if( i != 3 )
				IOB &= ~bmADCnSClkPin;
		}
		if( res1 != 0 )
		  	*res1++ = k;
		if( res2 != 0 )
			*res2++ = m;
	}
}

//void main(void)
//{
//	BYTE b1;
//	WORD w1, w2;
//	w1 = 0;
//	w2 = 42;
//	b1 = 32;
//	Foo( w1, w2, b1 );
//	Foo();
//}
	
